using System;
using Server;
using Server.Targeting;
using Server.Mobiles;
using System.Collections;

namespace Server.Items
{
    public class MandrakePlant : Item
    {

        [Constructable]
        public MandrakePlant() : base(6365) //6380
        {
            Weight = 1.0;
            Stackable = false;
            Name = "mandrake plant";
        }

        public MandrakePlant(Serial serial) : base(serial)
        {
        }
        
        public override void OnDoubleClick(Mobile from)
        {

            if (!IsChildOf(from.Backpack))
            {
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            }
            else if (from.InRange(this.GetWorldLocation(), 1))
            {
                this.SendLocalizedMessageTo(from, 1010086);
                from.Target = new MandrakePlantTarget(this);
            }
            else
            {
                from.SendLocalizedMessage(500446); // That is too far away. 
            }
        }
        
    		public override void GetProperties( ObjectPropertyList list )
    		{
    			base.GetProperties( list );
    
            list.Add("+5STR +5DEX +5INT +20Hits");
    		}

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }


        private class MandrakePlantTarget : Target
        {
            private Mobile m_Owner;

            private MandrakePlant m_Plant;

            public MandrakePlantTarget( MandrakePlant plant ) : base(10, false, TargetFlags.None)
            {
                m_Plant = plant;
            }

            protected override void OnTarget( Mobile from, object target )
            {
                if (target is BaseCreature)
                {
                    BaseCreature c = (BaseCreature)target;
                    if (c.Controlled == false)
                        from.SendMessage("Zvire musi byt ochocene.");
                    else if ( c.ControlMaster != from )
                        from.SendMessage("Toto neni tve zvire.");
                    else if ( c.IsDeadPet )
                        from.SendMessage("Nemuzes krmit mrtve zvire.");
                    else if ( c is BaseHire )
                        from.SendMessage("Nemuzes krmit najmute pomocniky");
                    else if ( c.Summoned || c is BaseTalismanSummon )
                        from.SendMessage("Nemuzes krmit vyvolane pomocniky.");
                    else if ( c is Xanthos.Interfaces.IEvoCreature && !GinsengPlant.IsAllowedEvoPet( (Xanthos.Interfaces.IEvoCreature) c ) )
                        from.SendMessage("Toto nemuze snist evolution pet.");
                    else if ( c.Controlled == true && c.ControlMaster == from )
                    {
                        if ( c.HitsMaxSeed > 1500 && c.RawStr > 1000 && c.RawDex > 250 && c.RawInt > 550 )
                           from.SendMessage("Toto zvire jiz dosahlo vsech maximalnich hodnot.");
                        else
                        {
                           if ( c.HitsMaxSeed < 1 ) c.HitsMaxSeed = c.RawStr;
                           if ( c.HitsMaxSeed < 1500 ) c.HitsMaxSeed += 20;
                           if ( c.RawStr < 1000 ) c.RawStr += 5;                           
                           if ( c.RawDex < 250 ) c.RawDex += 5;                           
                           if ( c.RawInt < 550 ) c.RawInt += 5;
                              
                           if ( c.StamMaxSeed < c.RawDex ) c.StamMaxSeed = c.RawDex;
                           if ( c.ManaMaxSeed < c.RawInt ) c.ManaMaxSeed = c.RawInt;
                           
          						if ( c.Body.IsAnimal )
          							c.Animate( 3, 5, 1, true, false, 0 );
          						else if ( c.Body.IsMonster )
          							c.Animate( 17, 5, 1, true, false, 0 );
                           
                           c.PlaySound( Utility.Random( 0x3A, 3 ) );
                           c.FixedParticles( 0x376A, 9, 32, 5008, EffectLayer.Waist );
                           m_Plant.Delete();
                           c.PlaySound( 0x1EE );
                        }
                    }
                     else
                     {
                        from.SendMessage("You cant do that.");
                     }
                }
                else
                {
                    from.SendMessage("Toto muzes snist jen tvoje ochocene zvire.");
                }
            }
        }
    }
}
